/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.tables.VWRoutingConditionTableModel;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWRoutingPanel
extends JPanel
implements IVWPropertyTab,
ListSelectionListener,
ActionListener,
IVWToolbarBorderActionListener,
IVWPropertyChangeListener,
IVWPropertyChangeSource,
IVWMapChangedListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMapNode m_currentMapNode = null;
    private Vector m_changedItems = null;
    private boolean m_bCollector = true;
    private JCheckBox m_collectorCheckBox = null;
    private JRadioButton m_andRadioBtn = null;
    private JRadioButton m_orRadioBtn = null;
    private VWToolbarBorder m_toolbarBorder = null;
    private VWTable m_routeTable = null;
    private VWRoutingConditionTableModel m_routeTableModel = null;

    public VWRoutingPanel(boolean bCollector) {
        this.m_bCollector = bCollector;
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 19;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            if (this.m_bCollector) {
                this.add((Component)this.createIncomingRoutingPanel(), gbCons);
                ++gbCons.gridx;
                gbCons.insets = new Insets(0, 15, 0, 0);
            }
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.add((Component)this.createOutgoingRoutingPanel(), gbCons);
            this.setSelectedStep(vwMapNode);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        this.m_currentMapNode = vwMapNode;
        if (this.m_routeTableModel != null) {
            this.m_routeTableModel.reinitialize(vwMapNode);
        }
        if (this.m_currentMapNode == null) {
            return;
        }
        if (this.m_bCollector) {
            if (this.m_currentMapNode.getJoinType() == 1) {
                this.m_collectorCheckBox.setSelected(true);
            } else {
                try {
                    this.m_collectorCheckBox.setSelected(false);
                    this.m_currentMapNode.setJoinType(2);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        if (this.m_currentMapNode.getSplitType() == 1) {
            this.m_andRadioBtn.setSelected(true);
        } else {
            try {
                this.m_orRadioBtn.setSelected(true);
                this.m_currentMapNode.setSplitType(2);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        this.valueChanged(null);
    }

    public void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        if (this.m_collectorCheckBox != null) {
            this.m_collectorCheckBox.removeActionListener(this);
            this.m_collectorCheckBox = null;
        }
        if (this.m_andRadioBtn != null) {
            this.m_andRadioBtn.removeActionListener(this);
            this.m_andRadioBtn = null;
        }
        if (this.m_orRadioBtn != null) {
            this.m_orRadioBtn.removeActionListener(this);
            this.m_orRadioBtn = null;
        }
        if (this.m_toolbarBorder != null) {
            this.m_toolbarBorder.removeToolbarBorderActionNotifier(this);
            this.m_toolbarBorder.releaseReferences();
            this.m_toolbarBorder = null;
        }
        if (this.m_routeTable != null) {
            this.m_routeTable.getSelectionModel().removeListSelectionListener(this);
            this.m_routeTable = null;
        }
        if (this.m_changedItems != null) {
            this.m_changedItems.removeAllElements();
            this.m_changedItems = null;
        }
        this.m_authPropertyData = null;
        this.m_currentMapNode = null;
    }

    public void valueChanged(ListSelectionEvent event) {
        int[] nSelectedRows = this.m_routeTable.getSelectedRows();
        JPanel source = this.m_toolbarBorder.getClientPanel();
        if (nSelectedRows.length == 0) {
            int nControls = 3;
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, nControls));
        } else {
            if (nSelectedRows[0] != 0) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 1));
            } else {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 1));
            }
            if (nSelectedRows[nSelectedRows.length - 1] != this.m_routeTableModel.getRowCount() - 1) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 2));
            } else {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 2));
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() == this.m_collectorCheckBox) {
                if (this.m_currentMapNode != null) {
                    if (this.m_collectorCheckBox.isSelected()) {
                        this.m_currentMapNode.setJoinType(1);
                    } else {
                        this.m_currentMapNode.setJoinType(2);
                    }
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(this.m_currentMapNode);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
                }
            } else if (event.getSource() == this.m_andRadioBtn) {
                if (this.m_currentMapNode != null) {
                    this.m_currentMapNode.setSplitType(1);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(this.m_currentMapNode);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 502);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
                }
            } else if (event.getSource() == this.m_orRadioBtn && this.m_currentMapNode != null) {
                this.m_currentMapNode.setSplitType(2);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_currentMapNode);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 502);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (this.m_routeTable == null) {
            return;
        }
        switch (event.getID()) {
            case 1: {
                int[] nSelectedRows = this.m_routeTable.getSelectedRows();
                this.m_routeTableModel.moveRoutesUp(nSelectedRows);
                this.m_authPropertyData.setDirty();
                this.adjustRowSelection(nSelectedRows, -1);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_currentMapNode);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 502);
                break;
            }
            case 2: {
                int[] nSelectedRows = this.m_routeTable.getSelectedRows();
                this.m_routeTableModel.moveRoutesDown(nSelectedRows);
                this.m_authPropertyData.setDirty();
                this.adjustRowSelection(nSelectedRows, 1);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_currentMapNode);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 502);
                break;
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            if (this.m_currentMapNode == null) {
                return;
            }
            switch (event.getID()) {
                case 501: {
                    if (this.m_routeTable == null) break;
                    this.m_routeTable.repaint();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public void mapChanged(VWMapChangedEvent event) {
        try {
            switch (event.getID()) {
                case 101: 
                case 102: {
                    VWRouteDefinition[] vwRouteDefs = this.m_authPropertyData.getMapChangeEventNotifier().getChangedRoutes();
                    if (vwRouteDefs == null || vwRouteDefs.length <= 0) break;
                    this.setSelectedStep(this.m_currentMapNode);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createIncomingRoutingPanel() {
        try {
            VWToolbarBorder incomingToolbarBorder = new VWToolbarBorder(VWResource.s_incomingRouting, 0x40000000);
            JPanel clientPanel = incomingToolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_collectorCheckBox = new JCheckBox(VWResource.s_collectorStep);
            this.m_collectorCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_collectorCheckBox, "First");
            return incomingToolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createOutgoingRoutingPanel() {
        try {
            this.m_toolbarBorder = new VWToolbarBorder(VWResource.s_outgoingRouting, 3);
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            JPanel clientPanel = this.m_toolbarBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 2, 3, 15);
            clientPanel.add((Component)new JLabel(VWResource.s_stepTakeRoutes), gbCons);
            ButtonGroup buttonGroup = new ButtonGroup();
            ++gbCons.gridy;
            gbCons.insets = new Insets(2, 2, 0, 15);
            this.m_andRadioBtn = new JRadioButton(VWResource.s_stepRouteAllTrue, true);
            this.m_andRadioBtn.addActionListener(this);
            buttonGroup.add(this.m_andRadioBtn);
            clientPanel.add((Component)this.m_andRadioBtn, gbCons);
            ++gbCons.gridy;
            this.m_orRadioBtn = new JRadioButton(VWResource.s_stepRouteFirstTrue, false);
            this.m_orRadioBtn.addActionListener(this);
            buttonGroup.add(this.m_orRadioBtn);
            clientPanel.add((Component)this.m_orRadioBtn, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 3;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            clientPanel.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 0;
            gbCons.insets = new Insets(0, 2, 3, 0);
            this.m_routeTableModel = new VWRoutingConditionTableModel();
            this.m_routeTable = new VWTable(this.m_routeTableModel);
            this.m_routeTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_routeTable.getSelectionModel().addListSelectionListener(this);
            clientPanel.add((Component)new JScrollPane(this.m_routeTable), gbCons);
            return this.m_toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void adjustRowSelection(int[] nSelectedRows, int nValue) {
        for (int i = 0; i < nSelectedRows.length; ++i) {
            int n = i;
            nSelectedRows[n] = nSelectedRows[n] + nValue;
            this.m_routeTable.getSelectionModel().addSelectionInterval(nSelectedRows[i], nSelectedRows[i]);
        }
    }
}

